/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.apple2e.MOS65C02;
import jace.core.Card;
import jace.core.Computer;
import jace.core.RAM;
import java.io.IOException;

public abstract class ProdosDriver {
    public static int MLI_COMMAND = 66;
    public static int MLI_UNITNUMBER = 67;
    public static int MLI_BUFFER_ADDRESS = 68;
    public static int MLI_BLOCK_NUMBER = 70;

    public abstract boolean changeUnit(int var1);

    public abstract int getSize();

    public abstract boolean isWriteProtected();

    public abstract void mliFormat() throws IOException;

    public abstract void mliRead(int var1, int var2) throws IOException;

    public abstract void mliWrite(int var1, int var2) throws IOException;

    public abstract Card getOwner();

    public void handleMLI() {
        int returnCode = this.prodosMLI().intValue;
        MOS65C02 cpu = (MOS65C02)Computer.getComputer().getCpu();
        cpu.A = returnCode;
        cpu.C = returnCode == 0 ? 0 : 1;
    }

    private MLI_RETURN prodosMLI() {
        try {
            int unit;
            RAM memory = Computer.getComputer().getMemory();
            byte cmd = memory.readRaw(MLI_COMMAND);
            MLI_COMMAND_TYPE command = MLI_COMMAND_TYPE.fromInt(cmd);
            int n = unit = (memory.readWordRaw(MLI_UNITNUMBER) & 0x80) > 0 ? 1 : 0;
            if (!this.changeUnit(unit)) {
                return MLI_RETURN.NO_DEVICE;
            }
            int block = memory.readWordRaw(MLI_BLOCK_NUMBER);
            int bufferAddress = memory.readWordRaw(MLI_BUFFER_ADDRESS);
            if (command == null) {
                System.out.println(this.getOwner().getName() + " Mass storage given bogus command (" + Integer.toHexString(cmd) + "), returning I/O error");
                return MLI_RETURN.IO_ERROR;
            }
            switch (command) {
                case STATUS: {
                    int blocks = this.getSize();
                    MOS65C02 cpu = (MOS65C02)Computer.getComputer().getCpu();
                    cpu.X = blocks & 0xFF;
                    cpu.Y = blocks >> 8 & 0xFF;
                    if (!this.isWriteProtected()) break;
                    return MLI_RETURN.WRITE_PROTECTED;
                }
                case FORMAT: {
                    this.mliFormat();
                }
                case READ: {
                    this.mliRead(block, bufferAddress);
                    break;
                }
                case WRITE: {
                    this.mliWrite(block, bufferAddress);
                    break;
                }
                default: {
                    System.out.println(this.getOwner().getName() + " MLI given bogus command (" + Integer.toHexString(cmd) + " = " + command.name() + "), returning I/O error");
                    return MLI_RETURN.IO_ERROR;
                }
            }
            return MLI_RETURN.NO_ERROR;
        }
        catch (UnsupportedOperationException ex) {
            return MLI_RETURN.WRITE_PROTECTED;
        }
        catch (IOException ex) {
            System.out.println(this.getOwner().getName() + " Encountered IO Error, returning error: " + ex.getMessage());
            return MLI_RETURN.IO_ERROR;
        }
    }

    public static enum MLI_COMMAND_TYPE {
        STATUS(0),
        READ(1),
        WRITE(2),
        FORMAT(3);

        public int intValue;

        private MLI_COMMAND_TYPE(int val) {
            this.intValue = val;
        }

        public static MLI_COMMAND_TYPE fromInt(int value) {
            for (MLI_COMMAND_TYPE c : MLI_COMMAND_TYPE.values()) {
                if (c.intValue != value) continue;
                return c;
            }
            return null;
        }
    }

    public static enum MLI_RETURN {
        NO_ERROR(0),
        IO_ERROR(39),
        NO_DEVICE(40),
        WRITE_PROTECTED(43);

        public int intValue;

        private MLI_RETURN(int val) {
            this.intValue = val;
        }
    }
}

